<?php

return [
    'title' => 'Налаштування',
    'general_setting' => 'Загальні налаштування',
    'menu' => 'Усі налаштування',
    'email_setting_title' => 'Налаштування електронної пошти',
    'email_setting_description' => 'Налаштуйте параметри електронної пошти',
    'general' => [
        'theme' => 'Тема',
        'title' => 'Загальна інформація',
        'description' => 'Перегляд та оновлення інформації про сайт',
        'rich_editor' => 'Розширений редактор',
        'site_title' => 'Заголовок сайту',
        'admin_email' => 'Електронна пошта адміністратора',
        'seo_block' => 'Конфігурація SEO',
        'seo_title' => 'SEO-заголовок',
        'seo_description' => 'SEO-опис',
        'webmaster_tools_block' => 'Інструменти вебмайстра Google',
        'placeholder' => [
            'site_title' => 'Заголовок сайту (максимум 120 символів)',
            'admin_email' => 'Електронна пошта адміністратора',
            'seo_title' => 'SEO-заголовок (максимум 120 символів)',
            'seo_description' => 'SEO-опис (максимум 120 символів)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Увімкнути надсилання звітів про помилки електронною поштою?',
        'time_zone' => 'Часовий пояс',
        'enable' => 'Увімкнути',
        'disable' => 'Вимкнути',
        'enable_cache' => 'Увімкнути кеш?',
        'disable_cache_in_the_admin_panel' => 'Вимкнути кеш в адміністративній панелі?',
        'disabled_helper' => 'Цей шаблон електронної пошти не можна вимкнути!',
        'cache_time' => 'Час кешування (хвилини)',
        'enable_cache_site_map' => 'Увімкнути кеш-карту сайту?',
        'cache_time_site_map' => 'Час кешування карти сайту (хвилини)',
        'admin_logo' => 'Логотип адміністратора',
        'admin_favicon' => 'Фавікон адміністратора',
        'admin_title' => 'Заголовок адміністратора',
        'admin_title_placeholder' => 'Заголовок, який відображається на вкладці браузера',
        'admin_appearance_title' => 'Зовнішній вигляд адміністратора',
        'admin_appearance_description' => 'Налаштування зовнішнього вигляду адміністратора, такі як редактор, мова...',
        'seo_block_description' => 'Налаштування заголовку сайту, метаопису сайту, ключових слів для оптимізації SEO',
        'webmaster_tools_description' => 'Інструменти вебмайстра Google (GWT) — безкоштовне програмне забезпечення, яке допомагає керувати технічними аспектами вашого веб-сайту',
        'yes' => 'Так',
        'no' => 'Ні',
        'show_on_front' => 'Ваш головний сторінка відображає',
        'select' => '— Вибрати —',
        'show_site_name' => 'Показувати назву сайту після заголовку сторінки, розділеного знаком "-"?',
        'locale' => 'Мова сайту',
        'locale_direction' => 'Напрямок мови сайту',
        'minutes' => 'хвилини',
        'redirect_404_to_homepage' => 'Перенаправляти всі запити, які не знайдено, на головну сторінку?',
    ],
    'admin_appearance' => [
        'title' => 'Зовнішній вигляд адміністратора',
        'description' => 'Перегляд та оновлення логотипу, фавікону, макету,...',
        'layout' => 'Макет',
        'horizontal' => 'Горизонтальний',
        'vertical' => 'Вертикальний',
        'show_menu_item_icon' => 'Показувати іконку елемента меню?',
        'language' => 'Мова в адміністративній панелі',
        'theme_mode' => 'Режим теми',
        'dark' => 'Темний',
        'light' => 'Світлий',
        'container_width' => [
            'title' => 'Ширина контейнера',
            'default' => 'За замовчуванням',
            'large' => 'Великий',
            'full' => 'Повний',
        ],
        'form' => [
            'admin_logo' => 'Логотип адміністратора',
            'admin_favicon' => 'Фавікон адміністратора',
            'admin_title' => 'Заголовок адміністратора',
            'admin_title_placeholder' => 'Заголовок, який відображається на вкладці браузера',
            'admin_login_screen_backgrounds' => 'Фони екрану входу (~1366x768)',
            'admin_locale_direction' => 'Напрямок мови адміністратора',
            'rich_editor' => 'Розширений редактор',
            'show_admin_bar' => 'Показувати адміністративну панель (Коли адміністратор увійшов у систему, все одно показувати адміністративну панель на веб-сайті)?',
            'show_guidelines' => 'Показувати інструкції?',
            'primary_font' => 'Основний шрифт',
            'primary_color' => 'Основний колір',
            'secondary_color' => 'Вторинний колір',
            'heading_color' => 'Колір заголовку',
            'text_color' => 'Колір тексту',
            'link_color' => 'Колір посилання',
            'link_hover_color' => 'Колір посилання при наведенні',
            'show_menu_item_icon' => 'Показувати іконку елемента меню?',
            'custom_css' => 'Користувацький CSS',
            'custom_js' => 'Користувацький JS',
            'custom_header_js' => 'JS заголовку',
            'custom_header_js_placeholder' => 'JS у заголовку сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'JS тіла',
            'custom_body_js_placeholder' => 'JS у тілі сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'JS футера',
            'custom_footer_js_placeholder' => 'JS у футері сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'admin_locale' => 'Мова адміністратора',
        ],
    ],
    'datatable' => [
        'title' => 'Таблиці даних',
        'description' => 'Налаштування для datatables',
        'form' => [
            'show_column_visibility' => 'Показувати видимість стовпця за замовчуванням?',
            'show_export_button' => 'Показувати кнопку експорту за замовчуванням?',
            'pagination_type' => 'Тип пагінації',
            'default' => 'За замовчуванням',
            'dropdown' => 'Випадаюче меню',
        ],
    ],
    'email' => [
        'subject' => 'Тема',
        'content' => 'Зміст',
        'title' => 'Налаштування шаблону електронної пошти',
        'description' => 'Шаблон електронної пошти з використанням HTML та системних змінних.',
        'reset_to_default' => 'Скинути до стандартних налаштувань',
        'back' => 'Повернутися до налаштувань',
        'reset_success' => 'Успішно скинуто до стандартних налаштувань',
        'confirm_reset' => 'Підтвердити скидання шаблону електронної пошти?',
        'confirm_message' => 'Ви дійсно хочете скинути цей шаблон електронної пошти до стандартних налаштувань?',
        'continue' => 'Продовжити',
        'sender_name' => 'Ім\'я відправника',
        'sender_name_placeholder' => 'Ім\'я',
        'sender_email' => 'Електронна пошта відправника',
        'mailer' => 'Поштовий клієнт',
        'port' => 'Порт',
        'port_placeholder' => 'Наприклад: 587',
        'host' => 'Хост',
        'host_placeholder' => 'Наприклад: smtp.gmail.com',
        'username' => 'Ім\'я користувача',
        'username_placeholder' => 'Ім\'я користувача для входу на поштовий сервер',
        'password' => 'Пароль',
        'password_placeholder' => 'Пароль для входу на поштовий сервер',
        'encryption' => 'Шифрування',
        'queue_warning_title' => 'Потрібне Налаштування Черги',
        'queue_warning_description' => 'Ваша черга електронної пошти наразі налаштована для використання драйвера ":default", але ваш воркер черги може не працювати. Це означає, що електронні листи не будуть відправлятися, доки ви не налаштуєте воркер черги.',
        'queue_warning_action' => 'Для негайного відправлення електронних листів без воркера черги, встановіть QUEUE_CONNECTION=sync у вашому файлі .env. В іншому випадку переконайтеся, що ваш воркер черги працює з "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Дізнайтеся більше про Laravel Queues</a>.',
        'mail_gun_domain' => 'Домен',
        'mail_gun_domain_placeholder' => 'Домен',
        'mail_gun_secret' => 'Секрет',
        'mail_gun_secret_placeholder' => 'Секрет',
        'mail_gun_endpoint' => 'Кінцева точка',
        'mail_gun_endpoint_placeholder' => 'Кінцева точка',
        'log_channel' => 'Канал журналу',
        'sendmail_path' => 'Шлях Sendmail',
        'encryption_placeholder' => 'Шифрування: ssl або tls',
        'local_domain' => 'Локальний домен',
        'local_domain_placeholder' => 'Може бути порожнім. Потрібно встановити на ваш домен при використанні SMTP Relay. Наприклад: your-domain.com',
        'ses_key' => 'Ключ',
        'ses_key_placeholder' => 'Ключ',
        'ses_secret' => 'Секрет',
        'ses_secret_placeholder' => 'Секрет',
        'ses_region' => 'Регіон',
        'ses_region_placeholder' => 'Регіон',
        'postmark_token' => 'Токен',
        'postmark_token_placeholder' => 'Токен',
        'email_templates' => 'Шаблони електронної пошти',
        'email_templates_description' => 'Шаблони електронної пошти з використанням HTML та системних змінних.',
        'email_template_settings' => 'Налаштування шаблону електронної пошти',
        'email_template_settings_description' => 'Перегляд та оновлення налаштувань шаблонів електронної пошти',
        'email_rules' => 'Правила електронної пошти',
        'email_rules_description' => 'Налаштуйте правила електронної пошти для валідації',
        'base_template' => 'Базовий шаблон',
        'base_template_description' => 'Базовий шаблон для всіх електронних листів',
        'template_header' => 'Заголовок шаблону електронної пошти',
        'template_header_description' => 'Шаблон для заголовка електронних листів',
        'template_footer' => 'Футер шаблону електронної пошти',
        'template_footer_description' => 'Шаблон для футера електронних листів',
        'default' => 'За замовчуванням',
        'template_off_status_helper' => 'Цей шаблон електронної пошти вимкнено.',
        'blacklist_email_domains' => 'Заблоковані домени електронної пошти',
        'blacklist_email_domains_helper' => 'Введіть список доменів електронної пошти, які будуть заблоковані. Наприклад: gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Заблоковані адреси електронної пошти',
        'blacklist_specified_emails_helper' => 'Введіть список конкретних адрес електронної пошти, які будуть заблоковані. Наприклад: mail@example.com.',
        'exception_emails' => 'Електронні листи-виключення',
        'exception_emails_helper' => 'Ці електронні листи будуть виключені з правил валідації.',
        'email_rules_strict' => 'Строга валідація електронної пошти',
        'email_rules_strict_helper' => 'Виконуйте валідацію електронної пошти подібну до RFC з суворими правилами.',
        'email_rules_dns' => 'Валідація перевірки DNS',
        'email_rules_dns_helper' => 'Перевірте, чи є DNS-записи, які вказують на те, що сервер приймає електронні листи.',
        'email_rules_spoof' => 'Виявлення підробки',
        'email_rules_spoof_helper' => 'Виявляйте можливі спроби підробки електронної пошти.',
        'template_turn_off' => 'Натисніть, щоб вимкнути цей шаблон електронної пошти',
        'template_turn_on' => 'Натисніть, щоб увімкнути цей шаблон електронної пошти',
        'turn_on_success_message' => 'Шаблон електронної пошти успішно увімкнено!',
        'turn_off_success_message' => 'Шаблон електронної пошти успішно вимкнено!',
        'email_template_status' => 'Статус шаблону електронної пошти',
        'email_template_status_description' => 'Увімкнути/вимкнути шаблон електронної пошти',
        'email_template_logo' => 'Логотип',
        'email_template_logo_helper_text' => 'Якщо не встановлено, він буде взятий з логотипу адміністратора в Адміністратор -> Налаштування -> Зовнішній вигляд адміністратора -> Логотип.',
        'email_template_copyright_text_helper_text' => 'Якщо не встановлено, він буде взятий з опцій теми авторського права в Адміністратор -> Зовнішній вигляд -> Опції теми -> Загальне -> Авторське право.',
        'email_template_email_contact' => 'Контактна адреса електронної пошти',
        'email_template_email_contact_helper_text' => 'Якщо не встановлено, він буде взятий з електронної пошти відправника в Адміністратор -> Налаштування -> Електронна пошта',
        'email_template_social_links' => 'Посилання на соціальні мережі',
        'email_template_copyright_text' => 'Авторське право',
        'image_upload_supported' => 'Підтримуються лише формати PNG, JPG, JPEG та GIF.',
        'email_template_custom_css' => 'Користувацький CSS шаблону електронної пошти',
        'social_links' => [
            'name' => 'Назва',
            'icon' => 'Іконка',
            'icon_image' => 'Зображення іконки (Підтримуються лише формати PNG, JPG, JPEG та GIF.)',
            'url' => 'URL',
            'image' => 'Зображення',
        ],
    ],
    'media' => [
        'title' => 'Медіа',
        'driver' => 'Драйвер',
        'description' => 'Налаштування для медіа',
        'aws_access_key_id' => 'ID ключа доступу AWS',
        'aws_secret_key' => 'Секретний ключ AWS',
        'aws_default_region' => 'Регіон за замовчуванням AWS',
        'aws_bucket' => 'Кошик AWS',
        'aws_url' => 'URL AWS',
        'aws_endpoint' => 'Кінцева точка AWS (Необов\'язково)',
        'r2_access_key_id' => 'ID ключа доступу R2',
        'r2_secret_key' => 'Секретний ключ R2',
        'r2_bucket' => 'Кошик R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Кінцева точка R2',
        'do_spaces_access_key_id' => 'ID ключа доступу DO Spaces',
        'do_spaces_secret_key' => 'Секретний ключ DO Spaces',
        'do_spaces_default_region' => 'Регіон за замовчуванням DO Spaces',
        'do_spaces_bucket' => 'Кошик DO Spaces',
        'do_spaces_endpoint' => 'Кінцева точка DO Spaces',
        'do_spaces_cdn_enabled' => 'Чи увімкнено CDN DO Spaces?',
        'media_do_spaces_cdn_custom_domain' => 'Користувацький домен CDN DO Spaces',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'ID ключа доступу Wasabi',
        'wasabi_secret_key' => 'Секретний ключ Wasabi',
        'wasabi_default_region' => 'Регіон за замовчуванням Wasabi',
        'wasabi_bucket' => 'Кошик Wasabi',
        'wasabi_root' => 'Корінь Wasabi',
        'wasabi_root_helper' => 'Щоб повторно використовувати існуючі зображення, просто призначте корінь Wasabi як "/", а потім завантажте всі поточні файли з public/storage у корінцеву директорію Wasabi.',
        'default_placeholder_image' => 'Зображення за замовчуванням',
        'enable_chunk' => 'Увімкнути завантаження за частинами?',
        'chunk_size' => 'Розмір частини (Байти)',
        'chunk_size_placeholder' => 'За замовчуванням: 1048576 ~ 1МБ',
        'max_file_size' => 'Максимальний розмір файлу частини (МБ)',
        'max_file_size_placeholder' => 'За замовчуванням: 1048576 ~ 1ГБ',
        'enable_watermark' => 'Увімкнути водяний знак?',
        'watermark_source' => 'Зображення водяного знака',
        'watermark_size' => 'Розмір водяного знака (%)',
        'watermark_size_placeholder' => 'За замовчуванням: 10 (%)',
        'watermark_opacity' => 'Прозорість водяного знака (%)',
        'watermark_opacity_placeholder' => 'За замовчуванням: 70 (%)',
        'watermark_position' => 'Позиція водяного знака',
        'watermark_position_x' => 'Позиція X водяного знака',
        'watermark_position_y' => 'Позиція Y водяного знака',
        'watermark_position_top_left' => 'Зверху ліворуч',
        'watermark_position_top_right' => 'Зверху праворуч',
        'watermark_position_bottom_left' => 'Знизу ліворуч',
        'watermark_position_bottom_right' => 'Знизу праворуч',
        'watermark_position_center' => 'Центр',
        'turn_off_automatic_url_translation_into_latin' => 'Вимкнути автоматичний переклад URL на латиницю',
        'bunnycdn_hostname' => 'Ім\'я хоста',
        'bunnycdn_zone' => 'Назва зони (Назва вашої зони зберігання)',
        'bunnycdn_key' => 'Пароль доступу через FTP та API (Пароль доступу до зони зберігання)',
        'bunnycdn_region' => 'Регіон (Регіон зони зберігання)',
        'optional' => 'Необов\'язково',
        'sizes' => 'Розміри медіа-мініатюр',
        'media_sizes_helper' => 'Встановіть ширину або висоту на 0, якщо ви хочете обрізати лише за шириною або висотою.',
        'width' => 'Ширина',
        'height' => 'Висота',
        'default_size_value' => 'За замовчуванням: :size',
        'all' => 'Усі',
        'all_helper_text' => 'Якщо ви знімаєте всі папки, це буде застосовано до всіх папок.',
        'media_folders_can_add_watermark' => 'Додати водяний знак до зображень у папках:',
        'max_upload_filesize' => 'Максимальний розмір файлу для завантаження (МБ)',
        'max_upload_filesize_placeholder' => 'За замовчуванням: :size, має бути менше ніж :size.',
        'max_upload_filesize_helper' => 'Ваш сервер дозволяє завантажувати файли максимум :size, ви можете змінити це значення, щоб обмежити розмір файлу для завантаження.',
        'image_processing_library' => 'Бібліотека обробки зображень',
        'use_original_name_for_file_path' => 'Використовувати оригінальну назву для шляху до файлу',
        'update_thumbnail_sizes_warning' => 'Після налаштування розмірів мініатюр потрібно натиснути кнопку ":button_text", щоб оновити їх.',
        'use_path_style_endpoint' => 'Використовувати кінцеву точку стилю шляху?',
        'keep_original_file_size_and_quality' => 'Зберігайте оригінальний розмір і якість файлу',
        'thumbnail_crop_position' => 'Позиція кадрування мініатюри',
        'thumbnail_crop_position_left' => 'Ліворуч',
        'thumbnail_crop_position_center' => 'центр',
        'thumbnail_crop_position_right' => 'правильно',
        'thumbnail_crop_position_top' => 'Топ',
        'thumbnail_crop_position_bottom' => 'Дно',
        'thumbnail_crop_position_helper' => 'Цей параметр використовується для обрізання зображення під час створення мініатюр. Воно буде обрізано з цієї позиції, доки зображення не буде заповнене.',
        'user_can_only_view_own_media' => 'Користувачі можуть переглядати лише власні медіафайли',
        'user_can_only_view_own_media_helper' => 'Якщо ввімкнено, користувачі можуть переглядати лише власні медіафайли, тоді як суперадміністратори можуть переглядати всі медіафайли.',
    ],
    'license' => [
        'purchase_code' => 'Код покупки',
        'buyer' => 'Покупець',
    ],
    'field_type_not_exists' => 'Цей тип поля не існує',
    'save_settings' => 'Зберегти налаштування',
    'template' => 'Шаблон',
    'description' => 'Опис',
    'enable' => 'Увімкнути',
    'send' => 'Надіслати',
    'test_email_description' => 'Щоб надіслати тестовий електронний лист, переконайтеся, що ви оновили конфігурацію для надсилання пошти!',
    'test_email_input_placeholder' => 'Введіть електронну адресу, на яку ви хочете надіслати тестовий електронний лист.',
    'test_email_modal_title' => 'Надіслати тестовий електронний лист',
    'test_send_mail' => 'Надіслати тестовий лист',
    'test_email_send_success' => 'Електронний лист успішно надіслано!',
    'locale_direction_ltr' => 'Зліва направо',
    'locale_direction_rtl' => 'Справа наліво',
    'emails_warning' => 'Ви можете додати максимум :count електронних листів',
    'email_add_more' => 'Додати більше',
    'generate' => 'Генерувати',
    'generate_thumbnails' => 'Генерувати мініатюри',
    'generate_thumbnails_success' => 'Мініатюри успішно згенеровані. :count файлів згенеровано!',
    'generate_thumbnails_error' => 'Нам не вдалося відновити мініатюри для цих файлів :count файлів!',
    'generate_thumbnails_description' => 'Ви впевнені, що хочете повторно згенерувати мініатюри для всіх зображень? Це займе час, тому, будь ласка, НЕ залишайте цю сторінку, дочекайтеся завершення.',
    'enable_chunk_description' => 'Завантаження за частинами використовується для завантаження великих файлів.',
    'watermark_description' => 'ПОПЕРЕДЖЕННЯ: Водяний знак додається лише до нових завантажених зображень, він не буде доданий до існуючих зображень. Вимкнення водяного знака не видалить водяний знак з існуючих зображень.',
    'submit' => 'Відправити',
    'back' => 'Назад',
    'enter_sample_value' => 'Введіть зразкові значення для тестування',
    'preview' => 'Попередній перегляд',
    'media_size_width' => 'Ширина розміру :size має бути більше 0',
    'media_size_height' => 'Висота розміру :size має бути більше 0',
    'cronjob' => [
        'name' => 'Кронджоб',
        'description' => 'Cronjob дозволяє автоматизувати певні команди або сценарії на вашому сайті.',
        'is_not_ready' => 'Щоб запустити cronjob, виконайте інструкції нижче.',
        'is_working' => 'Вітаємо! Ваш cronjob працює.',
        'is_not_working' => 'Ваш cronjob не працює. Будь ласка, перевірте cronjob на вашому сервері.',
        'last_checked' => 'Остання перевірка о :time.',
        'copy_button' => 'Копіювати',
        'setup' => [
            'name' => 'Налаштування Cronjob',
            'connect_to_server' => 'Підключіться до свого сервера через SSH або будь-який інший спосіб.',
            'open_crontab' => 'Відкрийте файл crontab за допомогою текстового редактора (наприклад, `crontab -e`).',
            'add_cronjob' => 'Додайте наведену вище команду до файлу crontab і збережіть його.',
            'done' => 'Тепер cronjob буде запускатися кожну хвилину і виконувати вказану команду.',
            'learn_more' => 'Ви можете дізнатися більше про cronjob з документації Laravel :documentation',
            'documentation' => 'документації',
            'copied' => 'Скопійовано',
        ],
    ],

    'security' => [
        'title' => 'Налаштування безпеки',
        'description' => 'Перевірте та налаштуйте параметри безпеки для вашого сайту.',
        'menu_description' => 'Керування безпекою cookie та HTTP-заголовками',
        'status_secure' => 'Усі налаштування безпеки правильно налаштовані!',
        'status_insecure' => 'Деякі налаштування безпеки потребують уваги!',
        'current_settings' => 'Поточні налаштування безпеки',
        'status' => 'Статус',
        'setting' => 'Налаштування',
        'current_value' => 'Поточне значення',
        'recommended_value' => 'Рекомендовано',
        'session_http_only' => 'Прапор HttpOnly Cookie',
        'session_http_only_description' => 'Запобігає доступу JavaScript до сесійних cookie (захист від XSS-атак)',
        'session_secure_cookie' => 'Прапор Secure Cookie',
        'session_secure_cookie_description' => 'Гарантує відправку cookie лише через HTTPS-з\'єднання',
        'session_same_site' => 'Прапор SameSite Cookie',
        'session_same_site_description' => 'Запобігає CSRF-атакам, обмежуючи відправку cookie',
        'http_security_headers' => 'Заголовки безпеки HTTP',
        'http_security_headers_description' => 'Додає заголовки безпеки для захисту від поширених веб-вразливостей',
        'https_warning' => 'Ваш сайт не використовує HTTPS',
        'https_warning_description' => 'Деякі функції безпеки, такі як захищені cookie, вимагають HTTPS. Розгляньте можливість увімкнення SSL для вашого сайту.',
        'how_to_fix' => 'Як виправити проблеми безпеки',
        'env_file_location' => 'Відредагуйте файл .env, розташований за адресою:',
        'add_to_env' => 'Налаштування для додавання',
        'required_settings' => 'Обов\'язкові налаштування безпеки',
        'for_https_sites' => 'Лише для сайтів HTTPS',
        'copy' => 'Копіювати',
        'copy_settings' => 'Копіювати всі налаштування',
        'copied' => 'Скопійовано!',
        'steps' => 'Кроки для застосування налаштувань',
        'step_1' => 'Відкрийте файл .env у текстовому редакторі',
        'step_2' => 'Додайте або оновіть налаштування безпеки, показані вище',
        'step_3' => 'Збережіть файл .env',
        'step_4' => 'Очистіть кеш через Панель адміністратора → Управління платформою → Управління кешем',
        'security_headers_info' => 'Інформація про заголовки безпеки',
        'security_headers_list' => 'При увімкненні до всіх відповідей додаються наступні заголовки:',
        'header_nosniff' => 'Запобігає вгадуванню типів вмісту браузерами',
        'header_frame' => 'Захищає від clickjacking-атак',
        'header_xss' => 'Вмикає захист XSS браузера',
        'header_referrer' => 'Контролює обсяг реферальної інформації, що відправляється',
        'learn_more' => 'Для отримання більш детальної інформації див. :documentation',
        'documentation' => 'документацію з безпеки',
    ],
    'cache' => [
        'title' => 'Кеш',
        'description' => 'Налаштування кешу для системи для оптимізації швидкості',
        'form' => [
            'enable_cache' => 'Увімкнути кеш?',
            'cache_time' => 'Час кешування (хвилини)',
            'disable_cache_in_the_admin_panel' => 'Вимкнути кеш в адміністративній панелі?',
            'cache_admin_menu' => 'Кешувати меню адміністратора?',
            'enable_cache_site_map' => 'Увімкнути кеш-карту сайту?',
            'cache_time_site_map' => 'Час кешування карти сайту (хвилини)',
        ],
    ],
    'appearance' => [
        'title' => 'Зовнішній вигляд',
    ],
    'panel' => [
        'common' => 'Загальні',
        'general' => 'Загальні',
        'general_description' => 'Перегляд та оновлення загальних налаштувань та активація ліцензії',
        'email' => 'Електронна пошта',
        'email_description' => 'Перегляд та оновлення налаштувань електронної пошти та шаблонів електронної пошти',
        'media' => 'Медіа',
        'media_description' => 'Перегляд та оновлення налаштувань медіа',
        'system' => 'Система',
        'system_updater' => 'Оновлювач системи',
        'system_updater_description' => 'Оновіть свою систему до останньої версії',
        'others' => 'Інші',
    ],
    'saving' => 'Збереження...',
    'generating_media_thumbnails' => 'Генерування мініатюр медіа...',
    'test_email_template' => 'Тестовий шаблон електронної пошти',
    'select_email_template' => 'Виберіть шаблон електронної пошти',
    'enums' => [
        'data_retention_period' => [
            365 => '1 Рік',
        ],
    ],
    'website_tracking' => [
        'title' => 'Відстеження веб-сайту',
        'description' => 'Налаштування відстеження веб-сайту',
        'google_tag_id' => 'Ідентифікатор тегу Google',
        'google_tag_id_placeholder' => 'Приклад: G-123ABC4567',
        'google_tag_code' => 'Код тегу Google',
    ],
];
