<?php

return [
    'name' => 'Produits',
    'description' => 'Voir et mettre à jour les paramètres de vos produits',
    'create' => 'Nouveau produit',
    'create_product_type' => [
        'physical' => 'Nouveau produit physique',
        'digital' => 'Nouveau produit numérique',
    ],
    'edit' => 'Modifier le produit - :name',
    'form' => [
        'name' => 'Nom',
        'name_placeholder' => 'Nom du produit (Maximum 120 caractères)',
        'description' => 'Description',
        'description_placeholder' => 'Description courte du produit (Maximum 400 caractères)',
        'categories' => 'Catégories',
        'content' => 'Contenu',
        'price' => 'Prix',
        'quantity' => 'Quantité',
        'brand' => 'Marque',
        'width' => 'Largeur',
        'height' => 'Hauteur',
        'weight' => 'Poids',
        'date' => [
            'start' => 'Date de début',
            'end' => 'Date de fin',
        ],
        'image' => 'Images',
        'collections' => 'Collections de produits',
        'labels' => 'Étiquettes',
        'price_sale' => 'Prix de vente',
        'product_type' => [
            'title' => 'Type de produit',
        ],
        'product' => 'Produit',
        'total' => 'Total',
        'sub_total' => 'Sous-total',
        'shipping_fee' => 'Frais d\'expédition',
        'discount' => 'Remise',
        'options' => 'Options',
        'shipping' => [
            'height' => 'Hauteur',
            'length' => 'Longueur',
            'title' => 'Expédition',
            'weight' => 'Poids',
            'wide' => 'Largeur',
        ],
        'barcode' => 'Code-barres (ISBN, UPC, GTIN, etc.)',
        'barcode_placeholder' => 'Entrer le code-barres',
        'cost_per_item' => 'Coût par article',
        'cost_per_item_placeholder' => 'Entrer le coût par article',
        'cost_per_item_helper' => "Les clients ne verront pas ce prix.",
        'stock' => [
            'allow_order_when_out' => 'Permettre au client de commander quand ce produit est en rupture de stock',
            'in_stock' => 'En stock',
            'out_stock' => 'Rupture de stock',
            'title' => 'Statut du stock',
        ],
        'storehouse' => [
            'no_storehouse' => 'Pas de gestion d\'entrepôt',
            'storehouse' => 'Avec gestion d\'entrepôt',
            'title' => 'Entrepôt',
            'quantity' => 'Quantité',
        ],
        'tax' => 'Taxe',
        'taxes' => 'Taxes',
        'taxes_helper' => 'Le taux de taxe par défaut est configuré dans <a href=":url">Paramètres -> Taxe</a>. Si aucune taxe spécifique n\'est sélectionnée pour ce produit, le taux par défaut sera appliqué. Pour désactiver la taxe pour ce produit, supprimez le taux de taxe par défaut des paramètres de taxe.',
        'is_default' => 'Par défaut',
        'action' => 'Action',
        'restock_quantity' => 'Quantité de réapprovisionnement',
        'remain' => 'Restant',
        'choose_discount_period' => 'Choisir la période de remise',
        'cancel' => 'Annuler',
        'no_results' => 'Aucun résultat !',
        'value' => 'Valeur',
        'attribute_name' => 'Nom de l\'attribut',
        'add_more_attribute' => 'Ajouter plus d\'attributs',
        'continue' => 'Continuer',
        'add_new_attributes' => 'Ajouter de nouveaux attributs',
        'add_new_attributes_description' => 'L\'ajout de nouveaux attributs aide le produit à avoir de nombreuses options, comme la taille ou la couleur.',
        'create_product_variations' => ':link pour créer des variations de produit !',
        'tags' => 'Tags',
        'write_some_tags' => 'Écrire quelques tags',
        'variation_existed' => 'Cette variation existe déjà.',
        'no_attributes_selected' => 'Aucun attribut sélectionné !',
        'added_variation_success' => 'Variation ajoutée avec succès !',
        'updated_variation_success' => 'Variation mise à jour avec succès !',
        'created_all_variation_success' => 'Toutes les variations créées avec succès !',
        'updated_product_attributes_success' => 'Attributs de produit mis à jour avec succès !',
        'stock_status' => 'Statut du stock',
        'auto_generate_sku' => 'Générer automatiquement le SKU ?',
        'featured_image' => 'Image en vedette (optionnel)',
        'product_id' => 'ID du produit',
        'price_sale_percent_helper' => 'Remise de :percent du prix original.',
        'minimum_order_quantity' => 'Quantité minimum de commande',
        'minimum_order_quantity_helper' => 'Quantité minimum pour passer une commande, si la valeur est 0, il n\'y a pas de limite.',
        'maximum_order_quantity' => 'Quantité maximum de commande',
        'maximum_order_quantity_helper' => 'Quantité maximum pour passer une commande, si la valeur est 0, il n\'y a pas de limite.',
        'video' => 'Vidéo',
        'video_file' => 'Fichier',
        'video_url' => 'Ou URL de vidéo externe',
        'video_url_help' => 'Entrer l\'URL de vidéo YouTube ou Vimeo',
        'enter_video_url' => 'Entrer l\'URL de la vidéo',
        'video_thumbnail' => 'Miniature de la vidéo',
        'video_thumbnail_help' => 'Choisir une miniature pour la vidéo. Si non sélectionnée, elle sera automatiquement récupérée depuis l\'URL de la vidéo si disponible.',
        'barcode_existed' => 'Ce code-barres est utilisé par un autre produit. Veuillez entrer un autre code-barres.',
        'barcode_helper' => 'Doit être unique pour chaque produit.',
    ],
    'price' => 'Prix',
    'quantity' => 'Quantité',
    'type' => 'Type',
    'image' => 'Miniature',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU de variation',
    'brand' => 'Marque',
    'cannot_delete' => 'Le produit n\'a pas pu être supprimé',
    'product_deleted' => 'Produit supprimé',
    'product_collections' => 'Collections de produits',
    'products' => 'Produits',
    'menu' => 'Produits',
    'control' => [
        'button_add_image' => 'Ajouter une image',
    ],
    'price_sale' => 'Prix de vente',
    'price_group_title' => 'Gérer le prix du produit',
    'store_house_group_title' => 'Gérer l\'entrepôt',
    'shipping_group_title' => 'Gérer l\'expédition',
    'overview' => 'Aperçu',
    'attributes' => 'Attributs',
    'product_has_variations' => 'Le produit a des variations',
    'manage_products' => 'Gérer les produits',
    'add_new_product' => 'Ajouter un nouveau produit',
    'start_by_adding_new_product' => 'Commencer par ajouter de nouveaux produits.',
    'edit_this_product' => 'Modifier ce produit',
    'delete' => 'Supprimer',
    'related_products' => 'Produits associés',
    'cross_selling_products' => 'Produits de vente croisée',
    'up_selling_products' => 'Produits de montée en gamme',
    'grouped_products' => 'Produits groupés',
    'search_products' => 'Rechercher des produits',
    'selected_products' => 'Produits sélectionnés',
    'edit_variation_item' => 'Modifier',
    'variations_box_description' => 'Cliquez sur "Modifier l\'attribut" pour ajouter/supprimer des attributs de variation ou cliquez sur "Ajouter une nouvelle variation" pour ajouter une variation.',
    'save_changes' => 'Enregistrer les modifications',
    'continue' => 'Continuer',
    'edit_attribute' => 'Modifier l\'attribut',
    'select_attribute' => 'Sélectionner l\'attribut',
    'add_new_variation' => 'Ajouter une nouvelle variation',
    'edit_variation' => 'Modifier la variation',
    'generate_variations' => 'Générer des variations',
    'generate_variations_confirmation' => 'Êtes-vous sûr de vouloir générer des variations pour ce produit ?',
    'delete_variation' => 'Supprimer la variation ?',
    'delete_variation_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette variation ? Cette action ne peut pas être annulée.',
    'delete_variations_confirmation' => 'Êtes-vous sûr de vouloir supprimer ces variations ? Cette action ne peut pas être annulée.',
    'product_create_validate_name_required' => 'Veuillez entrer le nom du produit',
    'product_create_validate_sale_price_max' => 'La remise doit être inférieure au prix original',
    'product_create_validate_cost_per_item_max' => 'Le coût par article doit être inférieur au prix original',
    'product_create_validate_sale_price_required_if' => 'Doit entrer une remise quand vous voulez planifier une promotion',
    'product_create_validate_end_date_after' => 'La date de fin doit être après la date de début',
    'product_create_validate_start_date_required_if' => 'La date de début de remise ne peut pas être laissée vide quand la planification est sélectionnée',
    'product_create_validate_sale_price' => 'Les remises ne peuvent pas être laissées vides quand la planification est sélectionnée',
    'stock_statuses' => [
        'in_stock' => 'En stock',
        'out_of_stock' => 'Rupture de stock',
        'on_backorder' => 'En commande en attente',
    ],
    'stock_status' => 'Statut du stock',
    'processing' => 'Traitement...',
    'delete_selected_variations' => 'Supprimer les variations sélectionnées',
    'delete_variations' => 'Supprimer les variations',
    'category' => 'Catégorie',
    'product_price_flash_sale_warning' => 'Ce produit est en vente flash <strong>:name</strong> donc son prix est <strong>:price</strong>.',
    'product_price_discount_warning' => 'Ce produit est en remise <strong>:name</strong> donc son prix est <strong>:price</strong>.',
    'product_image' => 'Image du produit',
    'product_name' => 'Nom du produit',
    'product_link' => 'Lien du produit',
    'types' => [
        'physical' => 'Physique',
        'digital' => 'Numérique',
    ],
    'digital_attachments' => [
        'title' => 'Pièces jointes numériques',
        'add' => 'Ajouter une pièce jointe',
        'file_name' => 'Nom du fichier',
        'file_size' => 'Taille du fichier',
        'unsaved' => 'Non enregistré',
        'add_external_link' => 'Ajouter un lien externe',
        'enter_file_name' => 'Entrer le nom du fichier',
        'enter_external_link_download' => 'Entrer le lien de téléchargement externe',
        'enter_file_size' => 'Entrer la taille du fichier',
        'external_link_download' => 'Lien de téléchargement externe',
        'generate_license_code_after_purchasing_product' => 'Activer l\'attribution de code de licence pour ce produit',
        'notify_attachment_updated' => 'Envoyer un email au client quand la pièce jointe est mise à jour',
    ],
    'license_codes' => [
        'title' => 'Codes de licence',
        'add' => 'Ajouter un code de licence',
        'back' => 'Retour au produit',
        'edit' => 'Modifier le code de licence',
        'generate' => 'Générer des codes',
        'manage_codes' => 'Gérer les codes de licence',
        'management' => 'Gestion des codes de licence',
        'variation_breadcrumb' => 'Variation : :name',
        'variation_label' => 'Variation de produit',
        'variation_specific_note' => 'Ces codes de licence sont spécifiques à cette variation de produit. Les clients qui achètent cette variation recevront des codes de ce pool.',
        'main_product_note' => 'Ce produit a des variations. Chaque variation peut avoir ses propres codes de licence, ou les clients peuvent recevoir des codes de ce pool de produit principal si la variation n\'a pas de codes.',
        'code' => 'Code de licence',
        'codes' => 'Codes de licence',
        'status' => 'Statut',
        'assigned_at' => 'Attribué le',
        'status_available' => 'Disponible',
        'status_used' => 'Utilisé',
        'statuses' => [
            'available' => 'Disponible',
            'used' => 'Utilisé',
        ],
        'no_codes' => 'Aucun code de licence trouvé. Ajoutez quelques codes ou générez-les automatiquement.',
        'no_codes_warning_title' => 'Aucun code de licence disponible !',
        'no_codes_warning_message' => 'Ce produit est défini sur "Choisir dans la liste" mais n\'a pas de codes de licence disponibles. Les clients qui achètent ce produit recevront des codes générés automatiquement à la place. Veuillez ajouter des codes de licence pour assurer un bon fonctionnement.',
        'no_codes_auto_generate' => 'Ce produit est défini pour générer automatiquement des codes de licence. Aucun code manuel nécessaire.',
        'used_code_no_actions' => 'Code utilisé - aucune action disponible',
        'created_successfully' => 'Code de licence créé avec succès !',
        'updated_successfully' => 'Code de licence mis à jour avec succès !',
        'deleted_successfully' => 'Code de licence supprimé avec succès !',
        'generated_successfully' => 'Généré :count codes de licence avec succès !',
        'duplicates_skipped' => ':count codes en double ont été ignorés.',
        'generation_incomplete' => 'Attention : Ne peut générer que :generated sur :requested codes demandés en raison de conflits de doublons.',
        'cannot_edit_used_code' => 'Impossible de modifier un code de licence utilisé.',
        'cannot_delete_used_code' => 'Impossible de supprimer un code de licence utilisé.',
        'show_all' => 'Montrer tout',
        'show_less' => 'Montrer moins',
        'more' => 'plus',
        'used_codes_hidden' => ':count code(s) de licence utilisé(s) sont cachés. Vous pouvez voir tous les codes dans la page de gestion des codes de licence.',
        'low_stock_title' => 'Stock de codes de licence faible',
        'low_stock_message' => 'Seulement :count codes de licence restants. Considérez ajouter plus de codes pour éviter d\'en manquer.',
        'out_of_stock_title' => 'Plus de codes de licence !',
        'out_of_stock_message' => 'Aucun code de licence disponible. Les clients recevront des codes générés automatiquement jusqu\'à ce que vous en ajoutiez plus.',
        'type' => [
            'title' => 'Méthode d\'attribution des codes de licence',
            'auto_generate' => 'Génération automatique (Le système génère les codes automatiquement)',
            'pick_from_list' => 'Choisir dans la liste (Utiliser les codes pré-entrés)',
            'description' => 'Choisissez comment les codes de licence doivent être attribués aux clients quand ils achètent ce produit.',
        ],
        'generate_modal' => [
            'title' => 'Générer des codes de licence',
            'quantity' => 'Quantité',
            'format' => 'Format',
            'custom_pattern' => 'Modèle personnalisé',
            'pattern_help' => 'Utilisez # pour les chiffres, A pour les lettres majuscules, a pour les lettres minuscules',
            'generate' => 'Générer',
        ],
        'errors' => [
            'feature_not_enabled' => 'La fonctionnalité des codes de licence n\'est pas activée. Veuillez l\'activer dans Paramètres E-commerce > Produits numériques.',
            'digital_products_not_enabled' => 'Les produits numériques ne sont pas activés. Veuillez d\'abord activer le support des produits numériques.',
            'product_not_found' => 'Produit non trouvé.',
            'not_digital_product' => 'Les codes de licence ne sont disponibles que pour les produits numériques. Ce produit est défini comme produit physique.',
            'license_codes_not_enabled_for_product' => 'La gestion des codes de licence n\'est pas activée pour ce produit. Veuillez activer "Générer un code de licence après l\'achat du produit" dans les paramètres du produit.',
            'cannot_add_codes_auto_generate' => 'Impossible d\'ajouter manuellement des codes de licence aux produits définis pour la génération automatique. Changez d\'abord le type de code de licence vers "Choisir dans la liste".',
            'cannot_generate_codes_auto_generate' => 'Impossible de générer manuellement des codes de licence pour les produits définis pour la génération automatique. Changez d\'abord le type de code de licence vers "Choisir dans la liste".',
        ],
        'copied' => 'Code de licence copié dans le presse-papiers !',
    ],
    'this_action_will_reload_page' => 'Cette action rechargera la page pour mettre à jour les données !',
    'select' => 'Sélectionner',
    'set_this_variant_as_default' => 'Définir cette variante comme par défaut',
    'download' => 'Télécharger',
    'cross_sell_price_type' => [
        'title' => 'Type de prix',
        'fixed' => 'Fixe',
        'percent' => 'Pourcentage',
    ],
    'cross_sell_help' => [
        'price' => '* Champ de prix',
        'price_description' => 'Entrez le montant que vous voulez réduire du prix original. Exemple : Si le prix original est 100€, entrez 20 pour réduire le prix à 80€.',
        'type' => '* Champ de type',
        'type_description' => 'Choisissez le type de remise : Fixe (réduire un montant spécifique) ou Pourcentage (réduire d\'un pourcentage).',
    ],
    'apply_for_all_variations' => 'Appliquer à toutes les variations',
    'export' => [
        'description' => 'Exportez vos données de produit vers des fichiers CSV ou Excel.',
        'total_items' => 'Articles totaux',
        'total_products' => 'Produits totaux',
        'total_variations' => 'Variations totales',
        'advanced_options' => 'Options avancées',
        'use_chunked_export' => 'Utiliser l\'exportation par chunks',
        'use_chunked_export_helper' => 'Traiter les données par chunks pour gérer efficacement les grands ensembles de données',
        'include_variations' => 'Inclure les variations de produit',
        'include_variations_helper' => 'Exporter les variations de produit avec les produits principaux',
        'optimize_memory' => 'Optimiser l\'utilisation de la mémoire',
        'optimize_memory_helper' => 'Activer l\'optimisation mémoire pour les très grandes exportations',
        'chunk_size' => 'Taille des chunks',
        'chunk_size_helper' => 'Nombre de produits à traiter à la fois (50-5000)',
        'use_streaming' => 'Utiliser l\'exportation en streaming',
        'use_streaming_helper' => 'Activer le streaming pour de très grands ensembles de données (activé automatiquement pour >10 000 articles)',
        'large_dataset_warning_title' => 'Grand catalogue de produits détecté',
        'large_dataset_warning_message' => 'Votre catalogue contient :count articles. En raison de la grande taille, certaines options d\'exportation ont été optimisées pour de meilleures performances.',
        'large_dataset_specific_message' => 'Pour vos :count produits, utilisez le format CSV avec le streaming activé. Le système peut maintenant gérer votre grand catalogue de produits efficacement sans timeouts ou problèmes de mémoire.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Requis)',
        'chunk_label' => 'Traitement',
        'chunk_recommended' => '300 produits/lot',
        'time_label' => 'Temps estimé',
        'time_estimate' => '1-3 minutes',
        'pro_tip' => 'Conseil pro :',
        'pro_tip_message' => 'L\'exportation continuera même si votre navigateur affiche un indicateur de chargement. Une fois démarrée, le téléchargement commencera automatiquement.',
        'large_dataset_tip_1' => 'Le format Excel a été désactivé - utilisez le format CSV pour des exportations plus rapides et plus fiables',
        'large_dataset_tip_2' => 'Le mode streaming a été automatiquement activé pour éviter les timeouts',
        'large_dataset_tip_3' => 'Le processus d\'exportation peut prendre 1-3 minutes selon votre serveur',
        'large_dataset_recommendation' => 'Recommandé : Utilisez le format CSV avec une taille de chunk de 200-500 pour des performances optimales.',
        'excel_disabled_for_large_export' => 'Format Excel non disponible pour les catalogues de plus de 10 000 articles',
        'streaming_auto_enabled' => 'Le mode streaming a été automatiquement activé pour des performances optimales avec de grands ensembles de données.',
        'streaming_enabled_title' => 'Optimisé pour grande exportation',
        'streaming_enabled_message' => 'Le mode streaming est actif pour assurer une exportation fluide sans problèmes de mémoire.',
        'recommended_range' => 'Plage recommandée',
        'range_large_export' => '200-500 articles',
        'range_medium_export' => '300-800 articles',
        'range_small_export' => '500-1000 articles',
        'export_progress' => 'Progression de l\'exportation',
        'preparing_export' => 'Préparation de l\'exportation...',
        'items_processed' => ':count articles traités',
        'estimated_time_calculating' => 'Temps estimé : calcul...',
        'medium_dataset_detected' => 'Ensemble de données moyen détecté',
        'medium_dataset_message' => 'Vous exportez :count produits. Considérez utiliser l\'exportation par chunks pour de meilleures performances.',
        'optimal_range' => 'Plage optimale',
        'too_small_slow' => 'Trop petit - peut être lent',
        'too_large_timeouts' => 'Trop grand - peut causer des timeouts',
        'excel_disabled_warning' => 'Format Excel désactivé pour les grandes exportations (:count articles)',
        'starting_export' => 'Démarrage de l\'exportation...',
        'processing_data' => 'Traitement des données...',
        'finalizing_export' => 'Finalisation de l\'exportation...',
        'items_processed_suffix' => 'articles traités',
        'estimated_time_prefix' => 'Temps estimé :',
        'seconds_remaining' => 's restantes',
        'export_completed' => 'Exportation terminée !',
        'download_starting' => 'Téléchargement en cours...',
    ],
    'import' => [
        'description' => 'Importez vos données de produit depuis des fichiers CSV ou Excel.',
        'rules' => [
            'in' => ':attribute doit être une des valeurs définies : :values.',
            'required_string_max' => ':attribute est requis et doit être une chaîne avec une longueur maximum de :max caractères.',
            'nullable_string' => ':attribute peut être laissé vide ou doit être une chaîne si fourni.',
            'nullable_string_max' => ':attribute peut être laissé vide ou doit être une chaîne avec une longueur maximum de :max caractères si fourni',
            'nullable_bool' => 'Si :attribute peut être laissé vide ou doit être une valeur booléenne si fourni.',
            'nullable_numeric_min' => ':attribute peut être laissé vide ou doit être un nombre non négatif si fourni.',
            'nullable_numeric_min_max' => ':attribute peut être laissé vide ou doit être un nombre entre :min et :max si fourni.',
            'nullable_array' => ':attribute peut être laissé vide ou doit être fourni comme un tableau si spécifié.',
            'nullable_date_required_if' => ':attribute peut être laissé vide ou doit être une date valide si fourni, requis si :required est spécifié.',
            'nullable_date_after' => ':attribute peut être laissé vide ou doit être une date valide après le :after si fourni.',
        ],
        'updated_message' => 'Mis à jour :count produits avec succès !',
    ],
    'import_products_intro' => 'Ou importer des produits depuis CSV/Excel',
    'select_attributes' => 'Sélectionner les attributs pour créer des variations :',
    'all' => 'Tous',
    'copy' => 'Copier',
    'product_translations' => 'Traductions de produit',
];